*___________________________________________________________________________________________________

	Simple multivariate analysis 02.sas

	This code does simulation and estimation of the simple microstructure model introduced in Chapter 8.
	m(t) = m(t-1) + w(t)
	w(t) = lambda * v(t) + u(t)
	q(t) = v(t) + beta*v(t-1)
	p(t) = m(t) + c*q(t)

	Note: The parameters of the q(t) process, beta and var(v) are estimated. Other parameters
	are set.

	This program uses the VarianceDecomp macro (in the '/SAS macros' subdirectory).

____________________________________________________________________________________________________;

*	Modify the following statement to set current directory to location of program;
x 'cd c:\Active\EMM Distribution\SAS Programs v0100';
options nodate nocenter nonumber ps=70 ls=120  sasautos=('./Sas Macros','.') mprint; 
libname SASData '.\Datasets';

ods pdf file='./Simple multivariate analysis 02.pdf' style=serifPrinter;

%let nObs=20000;
%let c=1;
%let lambda=2;
%let sdu=1;

title 'Simple multivariate analysis 02.sas';

title2 "Simulated data with c=&c, lambda=&lambda, and std.dev. of u = &sdu.";

data dsq;	*	Simulate the q process;
	u1 = normal(1234);
	do t=1 to &nObs;
		u = normal(2345);
		a = u + 0.5*u1;	*	This builds an MA(1) component into the q process;
		q = sign(round(u+u1,0.000000001));
		keep t q;
		output;
		u1 = u;
	end;
	run;
proc arima data=dsq;
	identify var=q nlag=5;
	estimate noint q=1;
	forecast out=dsq2 (drop=l95 u95 std forecast rename=(residual=v)) id=t;
	title2 'Estimate beta, var(v)';
	quit;
data pq;	*	Simulate the price process;
	retain m 0;
	set dsq2;
	u = &sdu*normal(3456);
	m = m + &lambda*v + u;
	p = m + &c*q;
	run;
title2;

*	Use the varmax procedure to estimate the VAR;
%let nImpulse=5;
proc varmax data=pq;
	model p q / p=4 dif=(p(1)) noint print=(impulse(&nImpulse)=(accum ortho)) lagmax=0 ;
	ods output covInnovation=covInnovation;
	ods output accumImpulse=accumImpulse;
	ods output orthoImpulse=orthoImpulse;
	run;
data lastAccumImpulse;
	set accumImpulse;
	where lag=&nImpulse and variable='p';
	drop lag;
	run;
*	Examine alternative variance decompositions;
%VarianceDecomp(dsCov=covInnovation, dsCoeff=lastAccumImpulse, RowLabel=variable);
%VarianceDecomp(dsCov=covInnovation, dsCoeff=lastAccumImpulse, RowLabel=variable, perm=q p);


title2	'Analyze the impact of an initial buy order.';
title3	'Note: varmax can only construct orthogonalized impulse response functions in the';
title4	'given order of the variables. So we need to re-estimate, placing q first.';
proc varmax data=pq;
	model q p / p=4 dif=(p(1)) noint print=(impulse(&nImpulse)=(accum ortho)) lagmax=0 ;
	ods output covInnovation=covInnovation;
	ods output orthoImpulse=orthoImpulse;
	run;
*	The orthogonalized impulse response functions produce by proc varmax
	assume a one-sd initial shock. Rescale by the sd of the q innovation
	to make the shock correspond to q=1 (a buy order).;
data qImpact;
	if _n_=1 then do;
		set covInnovation;
		std_q = sqrt(q);
		retain std_q;
	end;
	set orthoImpulse;
	q = q/std_q;
	keep lag q variable;
	rename lag=t;
proc transpose data=qImpact out=qImpactT (drop=_name_);
	var q;
	id variable;
	by t;
	run;
*	Cumulate the trade and price impacts;
data cumImpact;
	retain q 0 p 0;
	do i=0 to &nImpulse;
		set qImpactT (rename=(q=qCurrent p=pCurrent));
		q = q + qCurrent;
		p = p + pCurrent;
		output;
		keep t q p qCurrent pCurrent;
	end;
title 'Simple multivariate analysis 02.sas';
title2 'Impact of a buy order (q=+1 at time 0)';
proc print data=CumImpact;
	run;
symbol1 v=dot htext=2 ftext=duplex;
proc gplot data=cumImpact;
	plot p*t / hzero vzero;
	run;
	quit;
proc gplot data=cumImpact;
	plot q*t / hzero vzero;
	run;
	quit;

ods _all_ close;
